<?php
/**
 * Byzart.php
 *
 * @package Embera
 * @author Michael Pratt <yo@michael-pratt.com>
 * @link   http://www.michael-pratt.com/
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Embera\Provider;

use Embera\Url;

/**
 * Byzart Provider
 * The Byzart project aims to enhance Byzantine and Post-Byzantine archaeological and artistic heritage on Europeana.
 *
 * @link https://cmc.byzart.eu
 *
 */
class Byzart extends ProviderAdapter implements ProviderInterface
{
    /** inline {@inheritdoc} */
    protected $endpoint = 'https://cmc.byzart.eu/oembed/?format=json';

    /** inline {@inheritdoc} */
    protected static $hosts = [
        'cmc.byzart.eu'
    ];

    /** inline {@inheritdoc} */
    protected $httpsSupport = true;

    /** inline {@inheritdoc} */
    public function validateUrl(Url $url)
    {
        return (bool) (preg_match('~byzart\.eu/files/(?:.+)$~i', (string) $url));
    }

    /** inline {@inheritdoc} */
    public function normalizeUrl(Url $url)
    {
        $url->convertToHttps();
        $url->removeQueryString();
        return $url;
    }
}
