<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["category"] ) ) {
			$lookupTableLinks["category"] = array();
		}
		if( !isset( $lookupTableLinks["category"]["productitem.CateID"] )) {
			$lookupTableLinks["category"]["productitem.CateID"] = array();
		}
		$lookupTableLinks["category"]["productitem.CateID"]["edit"] = array("table" => "productitem", "field" => "CateID", "page" => "edit");
		if( !isset( $lookupTableLinks["supplier"] ) ) {
			$lookupTableLinks["supplier"] = array();
		}
		if( !isset( $lookupTableLinks["supplier"]["stockin.SupplierID"] )) {
			$lookupTableLinks["supplier"]["stockin.SupplierID"] = array();
		}
		$lookupTableLinks["supplier"]["stockin.SupplierID"]["edit"] = array("table" => "stockin", "field" => "SupplierID", "page" => "edit");
		if( !isset( $lookupTableLinks["stockin"] ) ) {
			$lookupTableLinks["stockin"] = array();
		}
		if( !isset( $lookupTableLinks["stockin"]["stockindetail.StockinID"] )) {
			$lookupTableLinks["stockin"]["stockindetail.StockinID"] = array();
		}
		$lookupTableLinks["stockin"]["stockindetail.StockinID"]["edit"] = array("table" => "stockindetail", "field" => "StockinID", "page" => "edit");
		if( !isset( $lookupTableLinks["productitem"] ) ) {
			$lookupTableLinks["productitem"] = array();
		}
		if( !isset( $lookupTableLinks["productitem"]["stockindetail.ProductID"] )) {
			$lookupTableLinks["productitem"]["stockindetail.ProductID"] = array();
		}
		$lookupTableLinks["productitem"]["stockindetail.ProductID"]["edit"] = array("table" => "stockindetail", "field" => "ProductID", "page" => "edit");
		if( !isset( $lookupTableLinks["province"] ) ) {
			$lookupTableLinks["province"] = array();
		}
		if( !isset( $lookupTableLinks["province"]["district.ProvinceID"] )) {
			$lookupTableLinks["province"]["district.ProvinceID"] = array();
		}
		$lookupTableLinks["province"]["district.ProvinceID"]["edit"] = array("table" => "district", "field" => "ProvinceID", "page" => "edit");
		if( !isset( $lookupTableLinks["province"] ) ) {
			$lookupTableLinks["province"] = array();
		}
		if( !isset( $lookupTableLinks["province"]["seeker_info.ProvinceID"] )) {
			$lookupTableLinks["province"]["seeker_info.ProvinceID"] = array();
		}
		$lookupTableLinks["province"]["seeker_info.ProvinceID"]["edit"] = array("table" => "seeker_info", "field" => "ProvinceID", "page" => "edit");
		if( !isset( $lookupTableLinks["district"] ) ) {
			$lookupTableLinks["district"] = array();
		}
		if( !isset( $lookupTableLinks["district"]["seeker_info.DistrictID"] )) {
			$lookupTableLinks["district"]["seeker_info.DistrictID"] = array();
		}
		$lookupTableLinks["district"]["seeker_info.DistrictID"]["edit"] = array("table" => "seeker_info", "field" => "DistrictID", "page" => "edit");
		if( !isset( $lookupTableLinks["categoryjob"] ) ) {
			$lookupTableLinks["categoryjob"] = array();
		}
		if( !isset( $lookupTableLinks["categoryjob"]["seeker_info.PositionApplyID"] )) {
			$lookupTableLinks["categoryjob"]["seeker_info.PositionApplyID"] = array();
		}
		$lookupTableLinks["categoryjob"]["seeker_info.PositionApplyID"]["edit"] = array("table" => "seeker_info", "field" => "PositionApplyID", "page" => "edit");
		if( !isset( $lookupTableLinks["categoryjobsub"] ) ) {
			$lookupTableLinks["categoryjobsub"] = array();
		}
		if( !isset( $lookupTableLinks["categoryjobsub"]["seeker_info.SubpositionApplyID"] )) {
			$lookupTableLinks["categoryjobsub"]["seeker_info.SubpositionApplyID"] = array();
		}
		$lookupTableLinks["categoryjobsub"]["seeker_info.SubpositionApplyID"]["edit"] = array("table" => "seeker_info", "field" => "SubpositionApplyID", "page" => "edit");
		if( !isset( $lookupTableLinks["salerepresentative"] ) ) {
			$lookupTableLinks["salerepresentative"] = array();
		}
		if( !isset( $lookupTableLinks["salerepresentative"]["seeker_info.SalepresentativeID"] )) {
			$lookupTableLinks["salerepresentative"]["seeker_info.SalepresentativeID"] = array();
		}
		$lookupTableLinks["salerepresentative"]["seeker_info.SalepresentativeID"]["edit"] = array("table" => "seeker_info", "field" => "SalepresentativeID", "page" => "edit");
		if( !isset( $lookupTableLinks["companyinfo"] ) ) {
			$lookupTableLinks["companyinfo"] = array();
		}
		if( !isset( $lookupTableLinks["companyinfo"]["seeker_appoint_interview.CompanyInterviewID"] )) {
			$lookupTableLinks["companyinfo"]["seeker_appoint_interview.CompanyInterviewID"] = array();
		}
		$lookupTableLinks["companyinfo"]["seeker_appoint_interview.CompanyInterviewID"]["edit"] = array("table" => "seeker_appoint_interview", "field" => "CompanyInterviewID", "page" => "edit");
}

?>